% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataForEstimation.R
\name{Load_Excel_Data}
\alias{Load_Excel_Data}
\title{Read data from Excel files and return a named list of data frames}
\usage{
Load_Excel_Data(ExcelFilePath)
}
\arguments{
\item{ExcelFilePath}{character. Path to the Excel file (.xlsx) to load. Must be a valid file path. The file can contain multiple sheets; each sheet will be loaded as a separate data frame in the output list.}
}
\value{
Named list of data frames, one for each sheet in the Excel file. The names of the list elements correspond to the sheet names.
}
\description{
Read data from Excel files and return a named list of data frames
}
\details{
Uses the readxl package to read all sheets from the specified Excel file. Each sheet is returned as a data frame. The output is a named list, with names matching the sheet names in the Excel file.
}
\examples{
if (!requireNamespace("readxl", quietly = TRUE)) {
  stop(
    "Please install package \"readxl\" to use this feature.",
    call. = FALSE
  )

  Load_Excel_Data(system.file("extdata", "MacroData.xlsx", package = "MultiATSM"))
  Load_Excel_Data(system.file("extdata", "YieldsData.xlsx", package = "MultiATSM"))
}
}
