/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewelcli.internal.fluentreflection;

import com.lexicalscope.jewelcli.internal.fluentreflection.$AbstractReflectedAnnotated;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ConvertTypeLiteralToReflectedType;
import com.lexicalscope.jewelcli.internal.fluentreflection.$IllegalAccessRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$IllegalArgumentRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$InvocationTargetRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedMethod;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedTypeFactory;
import com.lexicalscope.jewelcli.internal.fluentreflection.$Visibility;
import com.lexicalscope.jewelcli.internal.guice.$TypeLiteral;
import com.lexicalscope.jewelcli.internal.lamdaj.$Lambda;
import com.lexicalscope.jewelcli.internal.lang3.builder.$EqualsBuilder;
import com.lexicalscope.jewelcli.internal.lang3.builder.$HashCodeBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class $ReflectedMethodImpl
extends $AbstractReflectedAnnotated
implements $ReflectedMethod {
    private final $ReflectedTypeFactory reflectedTypeFactory;
    private final $ReflectedClass<?> reflectedClass;
    private final $TypeLiteral<?> typeLiteral;
    private final Method method;

    public $ReflectedMethodImpl($ReflectedTypeFactory reflectedTypeFactory, $ReflectedClass<?> reflectedClass, $TypeLiteral<?> typeLiteral, Method method) {
        super(reflectedTypeFactory, method);
        this.reflectedTypeFactory = reflectedTypeFactory;
        this.reflectedClass = reflectedClass;
        this.typeLiteral = typeLiteral;
        this.method = method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public List<$ReflectedClass<?>> argumentTypes() {
        ArrayList result = new ArrayList();
        result.addAll($Lambda.convert(this.typeLiteral.getParameterTypes(this.method), new $ConvertTypeLiteralToReflectedType(this.reflectedTypeFactory)));
        return result;
    }

    @Override
    public int argumentCount() {
        int parameterCount = this.method.getParameterTypes().length;
        if (this.isStatic()) {
            return parameterCount;
        }
        return parameterCount;
    }

    @Override
    public $ReflectedClass<?> declaringClass() {
        return this.reflectedTypeFactory.reflect(this.typeLiteral);
    }

    @Override
    public Object call(Object ... args) {
        if (this.isStatic()) {
            return this.invokeMethod(null, args);
        }
        if (args.length < 1) {
            throw new IllegalArgumentException("target instance must be specified as first argument when calling " + this.method);
        }
        Object[] remainingArguments = new Object[args.length - 1];
        System.arraycopy(args, 1, remainingArguments, 0, args.length - 1);
        return this.invokeMethod(args[0], remainingArguments);
    }

    private Object invokeMethod(Object instance, Object[] arguments) {
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            return this.method.invoke(instance, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new $IllegalArgumentRuntimeException(e, this.method, instance, arguments);
        }
        catch (IllegalAccessException e) {
            throw new $IllegalAccessRuntimeException(e, this.method);
        }
        catch (InvocationTargetException e) {
            throw new $InvocationTargetRuntimeException(e, this.method);
        }
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public $ReflectedClass<?> type() {
        $TypeLiteral<?> returnType = this.typeLiteral.getReturnType(this.method);
        if (returnType == null) {
            return null;
        }
        return this.reflectedTypeFactory.reflect(returnType);
    }

    @Override
    public String propertyName() {
        String name = this.getName();
        if (name.length() > 2) {
            if (name.length() > 3 && (name.startsWith("get") || name.startsWith("set"))) {
                return this.initialLowerCase(name.substring(3));
            }
            if (name.startsWith("is")) {
                return this.initialLowerCase(name.substring(2));
            }
        }
        return this.method.getName();
    }

    private String initialLowerCase(String substring) {
        return substring.substring(0, 1).toLowerCase() + substring.substring(1);
    }

    @Override
    public Method memberUnderReflection() {
        return this.method;
    }

    @Override
    public $Visibility visibility() {
        return $Visibility.visibilityFromModifiers(this.method.getModifiers());
    }

    private List<TypeVariable<Method>> typeParameters() {
        return Arrays.asList(this.method.getTypeParameters());
    }

    public String toString() {
        String string = this.visibility().toString().isEmpty() ? this.visibility().toString() : this.visibility().toString() + " ";
        String string2 = this.isStatic() ? "static " : "";
        String string3 = this.isFinal() ? "final " : "";
        String string4 = this.typeParameters().isEmpty() ? "" : "<" + $Lambda.joinFrom(this.typeParameters(), ", ").toString() + "> ";
        String string5 = this.argumentCount() > 0 ? $Lambda.joinFrom(this.argumentTypes(), ", ").toString() : "";
        return String.format("%s%s%s%s%s %s(%s)", string, string2, string3, string4, this.type(), this.method.getName(), string5);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            $ReflectedMethodImpl that = ($ReflectedMethodImpl)obj;
            return new $EqualsBuilder().append(this.method, that.method).append(this.typeLiteral, that.typeLiteral).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new $HashCodeBuilder().append(this.method).append(this.typeLiteral).toHashCode();
    }
}

