% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_outliers.R
\name{check_outliers}
\alias{check_outliers}
\title{Annotate a "nacho" object for outliers}
\usage{
check_outliers(nacho_object)
}
\arguments{
\item{nacho_object}{[\link{list}] A list object of class \code{"nacho"} obtained
from \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}}.}
}
\value{
A [\link{list}] object of class \code{"nacho"}.
}
\description{
Add or update \code{"is_outlier"} column in the \code{"nacho"} field of an object from
a call to \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}} (\code{nacho_object$nacho}),
using the current quality-control thresholds.
}
\examples{

data(GSE74821)
nacho_object <- check_outliers(GSE74821)
head(nacho_object$nacho)

}
