% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrend.R
\name{centrend}
\alias{centrend}
\title{Trend analysis of censored data with a covariate}
\usage{
centrend(
  y.var,
  y.cens,
  x.var,
  time.var,
  link = "identity",
  Smooth = "cs",
  printstat = TRUE
)
}
\arguments{
\item{y.var}{The column of y (response variable) values plus detection limits}

\item{y.cens}{The column of indicators, where 1 (or \code{TRUE}) indicates a detectionlimit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{x.var}{Column of a covariate (not time).  \code{y.var} will be smoothed versus \code{x.var} and residuals taken to subtract out the relationship between \code{y} and \code{x}.}

\item{time.var}{Column of the time variable, either a sequence of days or decimal times, etc.  Will be the scale used for time in ATS trend analysis.}

\item{link}{Default = \verb{“identity”} which means it uses data in the original units. See details.}

\item{Smooth}{Type of smoother used in the GAM. Default is \verb{“cs”}, shrinkage cubic regression splines. See details for other options.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Prints three plots: Y data vs time with GAM Smooth, Residuals from GAM Smooth vs time, and ATS trend line of residuals vs time.

Returns GAM residuals and ATS results on trend test of residuals (intercept, slope, Kendall's tau, p-value for trend)
}
\description{
Computes the ATS (Mann-Kendall trend test for censored data) after adjustment of censored data for a covariate.
}
\details{
Default \code{link} = identity. The y variables are then used in their original units. Other options are available see \code{cenGAM::tobit1} for more options.

Default \code{Smooth} is \code{"cs"} for shrinkage cubic regression splines. See \code{mgcv::smooth.terms} for other types of smoothing algorithms.  '"ts"' is a thin-plate regression spline and is also commonly used.
}
\examples{

data(Brumbaugh)

Brumbaugh$time=1:nrow(Brumbaugh)

with(Brumbaugh,centrend(Hg,HgCen,SedTotHg,time.var=time))
}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
\seealso{
\link[mgcv:gam]{mgcv::gam}
}
\keyword{GAM}
\keyword{analysis}
\keyword{spline}
\keyword{trend}
