% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenPredInt.R
\name{cenPredInt}
\alias{cenPredInt}
\title{Prediction interval for censored data}
\usage{
cenPredInt(
  y.var,
  cen.var,
  pi.type = "two-sided",
  conf = 0.95,
  newobs = 1,
  method = "mle",
  printstat = TRUE
)
}
\arguments{
\item{y.var}{The column of y (response variable) detected values plus detection limits}

\item{cen.var}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{pi.type}{Designation of either a \verb{“two-sided”} interval (default) or a 1-sided \verb{“upper”} or 1-sided \verb{“lower”} interval.}

\item{conf}{Confidence coefficient of the interval, 0.95 (default).}

\item{newobs}{The number of new observations to be contained in the interval.}

\item{method}{Character string specifying the method of estimation. Default is \code{mle} (maximum likelihood). See details.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
A table of prediction limits based on user provided confidence coefficient (\code{conf}) and prediction invterval type (\code{pi.type})
}
\description{
Computes prediction intervals for censored data assuming lognormal, gamma and normal distributions.
}
\details{
Computes prediction intervals for three distributions.  This is a front-end to the individual functions from the EnvStats package.  By default all three are computed using maximum likelihood estimation (mle). The gamma distribution for censored data uses the Wilson-Hilferty approximation (normal distribution on cube roots of data). Other methods are available in EnvStats, but few methods are available for all three distributions. For info on other methods, see help for elnormCensored and enormCensored commands in EnvStats.
}
\examples{
data(PbHeron)

# Default
cenPredInt(PbHeron$Liver,PbHeron$LiverCen)

# User defined confidence coefficient
cenPredInt(PbHeron$Liver,PbHeron$LiverCen, conf=0.5)

# User defined confidence coefficient outside of acceptable range
# the procedure will stop and give an error.
# cenPredInt(PbHeron$Liver,PbHeron$LiverCen, conf=1.1)

# User defined prediction interval type
cenPredInt(PbHeron$Liver,PbHeron$LiverCen,pi.type="lower")
cenPredInt(PbHeron$Liver,PbHeron$LiverCen,pi.type="upper")

}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Millard, S.P., 2013. EnvStats: An R Package for Environmental Statistics. Springer-Verlag, New York.

Krishnamoorthy, K., Mathew, T., Mukherjee, S., 2008. Normal-Based Methods for a Gamma Distribution, Technometrics, 50, 69-78.
}
\seealso{
\link[EnvStats:enormCensored]{EnvStats::enormCensored}
}
\keyword{interval}
\keyword{prediction}
