\name{NCA-package}
\alias{NCA-package}
\alias{NCA}
\docType{package}
\title{Necessary Condition Analysis}
\description{The NCA package implements Necessary Condition Analysis (NCA) as developed by Dul (2015). For running the NCA package a data file (e.g., mydata.csv, which contains the input data) must be available. An example data file (presented in above paper) is included in the package. The user must load the data and call the nca function. The call must be accompanied with parameters to fit the software to the specific situation.}
\details{\tabular{ll}{
    Package: \tab NCA\cr
    Type: \tab Package\cr
    Version: \tab 1.0\cr
    Date: \tab 2015-06-07\cr
    License: \tab GPL (>= 3)\cr}
}
\author{
Author: Jan Dul \email{jdul@rsm.nl}\cr
Maintainer: Govert Buijs \email{buijs@rsm.nl}
}

\references{
Dul, J. 2015. Necessary Condition Analysis (NCA).
\dQuote{Logic and Methodology of 'Necessary but not Sufficient' causality.}
This paper is published in Organizational Research Methods (Sage publishers)\cr
http://dx.doi.org/10.2139/ssrn.2588480). 

}

\keyword{package}

\examples{
  # Load data from a CSV file with header and row names:
  \donttest{data <- read.csv("mydata.csv", row.names=1)}
  # Or load the example dataset
  data(nca.example)
  data <- nca.example
  # Run NCA with the dataset
  # Specify the number of independent and dependent variables
  nca(data, 2, 1)
}
