% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{comify}
\alias{comify}
\title{Function to add commas for large numbers}
\usage{
comify(x, digits = 2)
}
\arguments{
\item{x}{a vector of numbers, either as character, integer or numeric form}

\item{digits}{integer, if decimal numbers are in use, how many digits to display, 
same as input to base::round()}
}
\value{
returns a character vector with commas inserted every 3 digits
}
\description{
Often for nice presentation of genomic locations it is helpful
to insert commas every 3 digits when numbers are large. This function
makes it simple and allows specification of digits if a decimal number
is in use.
}
\examples{
comify("23432")
comify(x=c(1,25,306,999,1000,43434,732454,65372345326))
comify(23432.123456)
comify(23432.123456,digits=0)
}

