% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity.r
\name{connectivity}
\alias{connectivity}
\title{Node degree distribution and network scale-freeness}
\usage{
connectivity(NET, Lowercase = 1, col.1 = 1, col.2 = 2, echo = 1,
  main = "Connectivity plot")
}
\arguments{
\item{NET}{Either a text network file or an R list imported with \code{import.net}}

\item{Lowercase}{Render gene/protein IDs lower-case.}

\item{col.1}{Number of the column in the input file that corresponds to node 1 (gene/protein ID).}

\item{col.2}{Number of the column in the input file that corresponds to node 2 (gene/protein ID).}

\item{echo}{if execution progress should be reported.}

\item{main}{The plot title.}
}
\description{
Auxiliary function to estimate how much a certain network satisfy the  property of scale-freeness.
}
\examples{
data(net.kegg)
net <- net.kegg
connectivity(NET=net, main="Scale-free property of KEGG network")
}
\seealso{
\code{\link{topology2nd}}, \code{\link{benchmark}}
}

