% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmCovariate}
\alias{chmCovariate}
\title{Get a covariate attached to an NG-CHM dataset.}
\usage{
chmCovariate(dataset, fullname, where)
}
\arguments{
\item{dataset}{The NG-CHM dataset to get the covariate from.}

\item{fullname}{The full name of the covariate to get.
If no covariate with that name exists, return NULL.}

\item{where}{The axis or axes on which to look for the covariate  Can be "row", "column", or "both" (default).}
}
\value{
A ngchmCovariate or NULL.
}
\description{
Get a covariate attached to an NG-CHM dataset.
}
\examples{
# If the NGCHMDemoData package is installed, use it to create demo usage
if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
  data(TCGA.GBM.Demo, package = "NGCHMDemoData")
  dataset <- chmNewDataset("gbmexpr", "TCGA GBM Expression Data", TCGA.GBM.ExpressionData)
  dataset <- chmAddCovariate(
    dataset, "column",
    chmNewCovariate("TP53 Mutation", TCGA.GBM.TP53MutationData)
  )
  tp53_mutation <- chmCovariate(dataset, "TP53 Mutation")
}
# Small example not requiring NGCHMDemoData
matrix <- matrix(rnorm(100),
  nrow = 10, ncol = 10,
  dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
)
dataset <- chmNewDataset("Demo", "Random Demo Dataset", matrix)
covariate <- setNames(rnorm(10), colnames(matrix))
dataset <- chmAddCovariate(dataset, "column", chmNewCovariate("Random Covariate", covariate))
random_covariate <- chmCovariate(dataset, "Random Covariate")

}
\seealso{
\linkS4class{ngchmCovariate}

chmNewCovariate

chmCovariateBar
}
