% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_plot.R
\name{util_plot}
\alias{util_plot}
\title{util_plot}
\usage{
util_plot(x, scale = "A", discrete = FALSE, legendposition = "bottom",
  legendtitle = "Z")
}
\arguments{
\item{x}{[\code{Raster* object}]}

\item{scale}{[\code{character}(1)]
Five options are available: "viridis - magma" (= "A",  the default option),
                            "viridis - inferno" (= "B"),
                            "viridis - plasma" (= "C"),
                            "viridis - viridis" (= "D")}

\item{discrete}{[\code{logical}(1)] If TRUE, the function plots a raster with
a discrete legend.}

\item{legendposition}{[\code{character}(1)] The position of legends
("none", "left", "right", "bottom", "top")}

\item{legendtitle}{[\code{character}(1)]
Title for legend}
}
\value{
ggplot2 Object
}
\description{
Plot a Raster* object with the NLMR default theme
}
\examples{

# With continuous data
nlm_raster <- nlm_random(10,10)
util_plot(nlm_raster, scale = "D")

# With classified data
y <- c(0.5, 0.15, 0.25)
nlm_raster <- util_classify(nlm_raster, y)
util_plot(nlm_raster, scale = "D", discrete = TRUE)

}
