% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMAforest.R
\name{NMAforest}
\alias{NMAforest}
\title{Generate Forest Plot with Proportion Contributions for Network Meta-analysis}
\usage{
NMAforest(
  data,
  sm = "OR",
  reference = "x",
  model = "random",
  comparison = c("x", "y"),
  study = "study",
  treat = "t",
  event = "r",
  N = "n",
  mean = "y",
  sd = "sd",
  id = "id",
  study_path = TRUE
)
}
\arguments{
\item{data}{A data frame containing the input data.}

\item{sm}{A Character string specifying the summary measure to use (e.g., "RR" for risk ratio, "OR" for odds ratio, "MD" for mean difference, "SMD" for standardized mean difference, etc.).}

\item{reference}{Specify the reference treatment for comparisons.}

\item{model}{Choose "random" or "fixed" effect model.}

\item{comparison}{A Vector of two treatments to compare.}

\item{study}{Column name identifying the study ID or label.}

\item{treat}{Column name for treatment assignment.}

\item{event}{Column name for event counts (for binary outcomes).}

\item{N}{Column name for total sample size (for binary outcomes).}

\item{mean}{Column name for mean values (for continuous outcomes).}

\item{sd}{Column name for standard deviations (for continuous outcomes).}

\item{id}{Column name used to uniquely identify each study arm (default = "id"). If the column is not present, one will be added.}

\item{study_path}{Logical. TRUE to include study combination contributions, FALSE to exclude.}
}
\value{
A list containing:
\describe{
  \item{plot}{A ggplot object of the forest plot.}
  \item{effects}{A data.frame with all effect sizes, confidence intervals, and weights.}
  \item{proportions}{A data.frame with proportion values.}
  \item{df_updated}{The input data frame with a unique \code{id} column added if not already present.}
}
}
\description{
This function extends the capabilities of network meta-analysis visualization by
generating a forest plot that incorporates direct, indirect, and network meta-analysis (NMA)
treatment effects, along with contribution proportions from individual studies and comparison paths.
It builds on the statistical foundation provided by the 'netmeta' package and is particularly useful
for evaluating the influence of study evidence in complex treatment networks.
}
\details{
This package includes an implementation of `comparisonStreams()` originally
developed by Papakonstantinou et al. (2018) and released with the paper's supplementary material.
}
\examples{
# Load example data from the package
data(example_data)
# Generate the forest plot and return effect estimates and proportion contributions
NMAforest(
  data = example_data,
  sm = "OR",
  reference = "x",
  model = "random",
  comparison = c("x", "y"),
  study = "study",
  treat = "t",
  event = "r",
  N = "n",
  id = "id",
  study_path = TRUE
)
}
\references{
Balduzzi, S., Rücker, G., Nikolakopoulou, A., Papakonstantinou, T., Salanti, G., Efthimiou, O., & Schwarzer, G. (2023).
netmeta: An R Package for Network Meta-Analysis Using Frequentist Methods. *Journal of Statistical Software*, 106(2), 1–40.
https://doi.org/10.18637/jss.v106.i02

Csardi, G., & Nepusz, T. (2006). The igraph software package for complex network research. *InterJournal*, Complex Systems, 1695.
https://igraph.org

Csárdi, G., Nepusz, T., Traag, V., Horvát, Sz., Zanini, F., Noom, D., & Müller, K. (2025).
*igraph: Network Analysis and Visualization in R*. https://doi.org/10.5281/zenodo.7682609

Wickham, H. (2016). *ggplot2: Elegant Graphics for Data Analysis*. Springer-Verlag New York.
https://ggplot2.tidyverse.org

Papakonstantinou, T., Nikolakopoulou, A., Rücker, G., Chaimani, A., Schwarzer, G., Egger, M., & Salanti, G. (2018).
Estimating the contribution of studies in network meta-analysis: paths, flows and streams. *F1000Research*, 7:610.
https://doi.org/10.12688/f1000research.14527.3

flow_contribution GitHub repository: https://github.com/esm-ispm-unibe-ch/flow_contribution
}
