;; 1. Based on: m1
;; 2. Description: 1CMT+oral
;; x1. Author: tarjinde

$PROBLEM ...

;; 4. Date: 01.01.2011
;; 5. Version: 1
;; 6. Label:
;; Basic model
;; 7. Structural model:
;; One compartment model
;; 8. Covariate model:
;; No covariates
;; 9. Inter-individual variability:
;; CL and V1.
;; 10. Inter-occasion variability:
;; No IOV
;; 11. Residual variability:
;; Additive + Proportional
;; 12. Estimation:
;; IMP

$INPUT
ID AMT TIME DV WT
$DATA ../DerivedData/data.csv IGNORE=@
$SUB ADVAN2

$PK

TVKA=EXP(THETA(1))
MU_1=LOG(TVKA)
KA = EXP(MU_1+ETA(1))

TVK=EXP(THETA(2))
MU_2=LOG(TVK)
K = EXP(MU_2+ETA(2))

TVV=EXP(THETA(3))
MU_3=LOG(TVV)
V = EXP(MU_3+ETA(3))

CL = K*V

S2 = V

$ERROR

IPRED=F
W=SQRT(SIGMA(1,1)*IPRED**2 + SIGMA(2,2))  ; proportional + additive error
IRES=DV-IPRED
IWRES=IRES/W
Y=IPRED + IPRED*EPS(1) + EPS(2)


$THETA
 0.41429    ; KA ; h-1 ; LOG
 -2.4444    ; K ; h-1 ; LOG
 -0.77189    ; V ; L ; LOG
$OMEGA
 0.49637			           ; IIV_KA ; LOG
 0.030144			           ; IIV_K ; LOG
 0.02156			           ; IIV_V ; LOG

$SIGMA
 0.019495    ; prop error
 0.052308    ; add error

$SIM (1234) ONLYSIM SUBPR=1

$TABLE ID TIME IPRED IWRES IRES CWRES NPDE
FILE=sdtabm1s_temp NOPRINT ONEHEADER
$TABLE ID ETAS(1:LAST); individual parameters
FILE=patabm1s_temp NOPRINT ONEHEADER
$TABLE ID ; continuous covariates
FILE=cotabm1s_temp NOPRINT ONEHEADER
$TABLE ID ; categorical covariates
FILE=catabm1s_temp NOPRINT ONEHEADER
