% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{map_nm}
\alias{map_nm}
\alias{map2_nm}
\alias{imap_nm}
\alias{pmap_nm}
\title{A purrr-like looping function over nm objects}
\usage{
map_nm(.x, .f, ...)

map2_nm(.x, .y, .f, ...)

imap_nm(.x, .f, ...)

pmap_nm(.l, .f, ...)
}
\arguments{
\item{.x}{An nm object.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.y}{An optional nm object.}

\item{.l}{A list of vectors, such as a data frame. The length of \code{.l}
determines the number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\value{
A modified nm object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Loop over an nm object when a vectorized operation is not available.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))
                                       
## vectorized run
m1 \%>\% child(1:3) \%>\% run_id(paste0(run_id(.), "modified"))
  
m1 \%>\% child(1:3) \%>\% 
  map_nm(~ .x \%>\% run_id(paste0(run_id(.), "modified")))
  


}
