% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Co_PM_cor.R
\name{Co.PM.cor}
\alias{Co.PM.cor}
\title{Co-Partial Moments Higher Dimension Correlation}
\usage{
Co.PM.cor(A)
}
\arguments{
\item{A}{data.frame of variables.}
}
\value{
Returns multivariate nonlinear correlation coefficient
}
\description{
Determines higher dimension correlation coefficients based on degree 0 co-partial moments.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100); z<-rnorm(100)
A<-data.frame(x,y,z)
Co.PM.cor(A)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. (2016) "Beyond Correlation: Using the Elements of Variance for Conditional Means and Probabilities"  \url{http://ssrn.com/abstract=2745308}.
}

