% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRejections.R
\name{make_corr_mat}
\alias{make_corr_mat}
\title{Makes correlation matrix to simulate data}
\usage{
make_corr_mat(nX, nY, rho.XX, rho.YY, rho.XY, prop.corr = 1)
}
\arguments{
\item{nX}{Number of covariates, including the one of interest}

\item{nY}{Number of outcomes}

\item{rho.XX}{Correlation between all pairs of Xs}

\item{rho.YY}{Correlation between all pairs of Ys}

\item{rho.XY}{Correlation between pairs of X-Y that are not null (see below)}

\item{prop.corr}{Proportion of X-Y pairs that are non-null (non-nulls will be first \code{prop.corr} * \code{nY} pairs)}
}
\description{
Simulates a dataset with a specified number of standard MVN covariates and outcomes
with a specified correlation structure. If the function returns an error stating that
the correlation matrix is not positive definite,
try reducing the correlation magnitudes.
}
\examples{
make_corr_mat( nX = 1,
nY = 4,
rho.XX = 0,
rho.YY = 0.25,
rho.XY = 0,
prop.corr = 0.8 )
}
