% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRejections.R
\name{resample_resid}
\alias{resample_resid}
\title{Resample residuals for OLS}
\usage{
resample_resid(d, X, C = NA, Ys, alpha, resid, bhat.orig, B = 2000,
  cores = NULL)
}
\arguments{
\item{d}{Dataframe}

\item{X}{Single quoted name of covariate of interest}

\item{C}{Vector of quoted covariate names}

\item{Ys}{Vector of quoted outcome names}

\item{alpha}{Alpha level for individual tests}

\item{resid}{Residuals from original sample (W X B matrix)}

\item{bhat.orig}{Estimated coefficients for covariate of interest in original sample (W-vector)}

\item{B}{Number of resamples to generate}

\item{cores}{Number of cores available for parallelization}
}
\value{
Returns a list containing the number of rejections in each resample, a matrix of p-values
in the resamples, and a matrix of t-statistics in the resamples.
}
\description{
Implements the residual resampling OLS algorithm described in Mathur & VanderWeele (in preparation). 
Specifically, the design matrix is fixed while the resampled outcomes are set equal to the original fitted values
plus a vector of residuals sampled with replacement.
}
\examples{
samp.res = dataset_result( X = "complaints",
                C = c("privileges", "learning"),
                Ys = c("rating", "raises"),
                d = attitude,
                center.stats = FALSE,
                bhat.orig = NA,  # bhat.orig is a single value now for just the correct Y
                alpha = 0.05 )

resamps = resample_resid(  X = "complaints",
                  C = c("privileges", "learning"),
                  Ys = c("rating", "raises"),
                  d = attitude,
                  alpha = 0.05,
                  resid = samp.res$resid,
                  bhat.orig = samp.res$b,
                  B=20,
                  cores = 2)
}
\references{
Mathur, M.B., & VanderWeele, T.J. (in preparation). New metrics for multiple testing with correlated
outcomes.
}
