% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{SMC}
\alias{SMC}
\title{Generic Sequential Monte Carlo Method}
\usage{
SMC(Sstep, nobs, yy, mm, par, xx.init, xdim, ydim, resample.sch,
  delay = 0, funH = identity)
}
\arguments{
\item{Sstep}{a function that performs one step propagation using a proposal distribution.
Its input includes \code{(mm,xx,logww,yyy,par,xdim,ydim)}, where
\code{xx} and \code{logww} are the last iteration samples and log weight. \code{yyy} is the
observation at current time step. It should return \code{xx} (the samples xt) and
\code{logww} (their corresponding log weight).}

\item{nobs}{the number of observations \code{T}.}

\item{yy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{mm}{the Monte Carlo sample size.}

\item{par}{a list of parameter values to pass to \code{Sstep}.}

\item{xx.init}{the initial samples of \code{x_0}.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample.sch}{a binary vector of length \code{nobs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}

\item{delay}{the maximum delay lag for delayed weighting estimation. Default is zero.}

\item{funH}{a user supplied function \code{h()} for estimation \code{E(h(x_t) | y_t+d}). Default
is identity for estimating the mean. The function should be able to take vector or matrix as input and operates on each element of the input.}
}
\value{
The function returns \code{xhat}, an array with dimensions \code{(xdim; nobs; delay+1)},
and the scaled log-likelihood value \code{loglike}. If \code{loglike} is needed, the log weight
calculation in the \code{Sstep} function should retain all constants that are related to
the parameters involved. Otherwise, \code{Sstep} function may remove all constants
that are common to all the Monte Carlo samples. It needs a utility function
\code{circular2ordinal}, also included in the \code{NTS} package, for efficient memory management.
}
\description{
Function of generic sequential Monte Carlo method with delay weighting not using full information proposal distribution.
}
\examples{
nobs= 100; pd= 0.95; ssw= 0.1; ssv= 0.5;
xx0= 0; ss0= 0.1; nyy= 50;
yrange= c(-80,80); xdim= 2; ydim= nyy;
mm= 10000
yr=yrange[2]-yrange[1]
par=list(ssw=ssw,ssv=ssv,nyy=nyy,pd=pd,yr=yr)
simu=simuTargetClutter(nobs,pd,ssw,ssv,xx0,ss0,nyy,yrange)
xx.init=matrix(nrow=2,ncol=mm)
xx.init[1,]=yrange[1]+runif(mm)*yr
xx.init[2,]=rep(0.1,mm)
resample.sch=rep.int(1,nobs)
out= SMC(Sstep.Clutter,nobs,simu$yy,mm,par,xx.init,xdim,ydim,resample.sch)
}
\references{
Tsay, R. and Chen, R. (2019). Nonlinear Time Series Analysis. Wiley, New Jersey.
}
