% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{clutterKF}
\alias{clutterKF}
\title{Kalman Filter for Tracking in Clutter}
\usage{
clutterKF(nobs, ssw, ssv, yy, ii)
}
\arguments{
\item{nobs}{the number of observations.}

\item{ssw}{the standard deviation in the state equation.}

\item{ssv}{the standard deviation for the observation noise.}

\item{yy}{the data.}

\item{ii}{the indicators.}
}
\value{
The function returns a list with the following components:
\item{xhat}{the fitted location.}
\item{shat}{the fitted speed.}
}
\description{
This function implements Kalman filter to track a moving target under clutter environment with known indicators.
}
\examples{
nobs <- 100; pd <- 0.95; ssw <- 0.1; ssv <- 0.5;
xx0 <- 0; ss0 <- 0.1; nyy <- 50;
yrange <- c(-80,80); xdim <- 2; ydim <- nyy;
simu <- simuTargetClutter(nobs,pd,ssw,ssv,xx0,ss0,nyy,yrange)
outKF <- clutterKF(nobs,ssw,ssv,simu$yy,simu$ii)
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
