% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{mTAR.sim}
\alias{mTAR.sim}
\title{Generate Two-Regime (TAR) Models}
\usage{
mTAR.sim(
  nob,
  thr,
  phi1,
  phi2,
  sigma1,
  sigma2 = NULL,
  c1 = NULL,
  c2 = NULL,
  delay = c(1, 1),
  ini = 500
)
}
\arguments{
\item{nob}{number of observations.}

\item{thr}{threshold value.}

\item{phi1}{VAR coefficient matrix of regime 1.}

\item{phi2}{VAR coefficient matrix of regime 2.}

\item{sigma1}{innovational covariance matrix of regime 1.}

\item{sigma2}{innovational covariance matrix of regime 2.}

\item{c1}{constant vector of regime 1.}

\item{c2}{constant vector of regime 2.}

\item{delay}{two elements (i,d) with "i" being the component index and "d" the delay for threshold variable.}

\item{ini}{burn-in period.}
}
\value{
mTAR.sim returns a list with following components:
\item{series}{a time series following the multivariate two-regime  VAR model.}
\item{at}{innovation of the time series.}
\item{threshold}{threshold value.}
\item{delay}{two elements (i,d) with "i" being the component index and "d" the delay for threshold variable.}
\item{n1}{number of observations in regime 1.}
\item{n2}{number of observations in regime 2.}
}
\description{
Generates multivariate two-regime threshold autoregressive models.
}
\examples{
phi1=matrix(c(0.5,0.7,0.3,0.2),2,2)
phi2=matrix(c(0.4,0.6,0.5,-0.5),2,2)
sigma1=matrix(c(1,0,0,1),2,2)
sigma2=matrix(c(1,0,0,1),2,2)
c1=c(0,0)
c2=c(0,0)
delay=c(1,1)
y=mTAR.sim(100,0,phi1,phi2,sigma1,sigma2,c1,c2,delay,ini=500)
}
