% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.mmsbm.R
\name{coef.mmsbm}
\alias{coef.mmsbm}
\title{Extract Regression Coefficients for a Fitted \code{mmsbm} Object}
\usage{
\method{coef}{mmsbm}(object, param = "All", ...)
}
\arguments{
\item{object}{An object of class \code{mmsbm}, a result of a call to \code{mmsbm}}

\item{param}{Character string, which set of parameters should the vcov be extracted for? One
of \code{"MonadCoef"}, \code{"DyadCoef"} or \code{"All"} (the default).}

\item{...}{Currently ignored}
}
\value{
For \code{param="DyadCoef"}, a numeric vector. For \code{param="MonadCoef"}, an array
        with HMM states along the third dimension. For \code{param="All"}, named list of individual return components.
}
\description{
Extract Regression Coefficients for a Fitted \code{mmsbm} Object
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2,
                      mmsbm.control = list(seed = 123,
                                           hessian = FALSE))

coef(lazega_mmsbm, "MonadCoef")

}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
