% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pperm.R
\name{permutation}
\alias{permutation}
\alias{permutationTest}
\alias{permuted}
\alias{requiredPerms}
\title{Permutation test P-values for module preservation statistics}
\usage{
permutationTest(nulls, observed, nVarsPresent, totalSize,
  alternative = "greater")

requiredPerms(alpha, alternative = "greater")
}
\arguments{
\item{nulls}{a 3-dimension matrix where the columns correspond to module
preservation statistics, rows correspond to modules, and the third 
dimension to null distribution observations drawn from the permutation 
procedure in \code{\link{modulePreservation}}.}

\item{observed}{a matrix of observed values for each module preservation
statistc (columns) for each module (rows) returned from 
\code{\link{modulePreservation}}.}

\item{nVarsPresent}{a vector containing the number of variables/nodes in each
module that was present in the \emph{test} dataset. Returned as a list 
element of the same name by \code{\link{modulePreservation}}.}

\item{totalSize}{the size of the test network used to perform the test. 
Returned as a list element of the same name by 
\code{\link{modulePreservation}}.}

\item{alternative}{a character string specifying the alternative hypothesis, 
must be one of "greater" (default), "less", or "two.sided". 
You can specify just the initial letter.}

\item{alpha}{desired significance threshold.}
}
\value{
The minimum number of permutations required to detect any significant
 associations at the provided \code{alpha}. The minimum p-value will always
 be smaller than \code{alpha}.
}
\description{
Evaluates the statistical significance of each module preservation test 
statistic for one or more modules.

\code{requiredPerms}:  how many permutations do I need to be able to detect
 significance at a given threshold \code{alpha}?
}
\details{
Calculates exact p-values for permutation tests when permutations are 
 randomly drawn with replacement using the \code{\link[statmod]{permp}} 
 function in the \code{\link{statmod}} package. 
 
 This function may be useful for re-calculating permutation test P-values,
 for example when there are missing values due to sparse data. In this case
 the user may decide that these missing values should be assigned 0 so that
 P-values aren't signficant purely due to many incalculable statistics leading
 to low power.
}
\examples{
data("NetRep")

# Set up input lists for each input matrix type across datasets. The list
# elements can have any names, so long as they are consistent between the
# inputs.
network_list <- list(discovery=discovery_network, test=test_network)
data_list <- list(discovery=discovery_data, test=test_data)
correlation_list <- list(discovery=discovery_correlation, test=test_correlation)
labels_list <- list(discovery=module_labels)

# How many permutations are required to Bonferroni adjust for the 4 modules 
# in the example data? 
nPerm <- requiredPerms(0.05/4) 

# Note that we recommend running at least 10,000 permutations to make sure 
# that the null distributions are representative.

preservation <- modulePreservation(
 network=network_list, data=data_list, correlation=correlation_list, 
 moduleAssignments=labels_list, nPerm=nPerm, discovery="discovery", 
 test="test"
)

# Re-calculate the permutation test P-values
p.values <- permutationTest(
  preservation$nulls, preservation$observed, preservation$nVarsPresent,
  preservation$totalSize, preservation$alternative
)

}
\references{
\enumerate{
    \item{
      Phipson, B. & Smyth, G. K. \emph{Permutation P-values should never be 
      zero: calculating exact P-values when permutations are randomly drawn.}
      Stat. Appl. Genet. Mol. Biol. \strong{9}, Article39 (2010). 
    }
  }
}

