% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{PureIBNRLNorm}
\alias{PureIBNRLNorm}
\title{Pure IBNR exposure from a LogNormal reporting delay distribution}
\usage{
PureIBNRLNorm(IncDate, ExpDate, ValDate, mu, sigma)
}
\arguments{
\item{IncDate}{A date -  the inception date of the period.}

\item{ExpDate}{A date -  the expiry date of the period. Must be greater than inception date.}

\item{ValDate}{A date -  the valuation date.}

\item{mu}{A real number - the first parameter of the reporing delay's LogNormal distribution.}

\item{sigma}{A positive real number - the second parameter of the reporing delay's LogNormal distribution.}
}
\value{
Unearned and Pure IBNR exposure in days and as a percentage of the period's duration, where the reporting delay has a LogNormal distribution with parameters \code{mu} and \code{sigma}.
}
\description{
Pure IBNR exposure from a LogNormal reporting delay distribution
}
\examples{
Dates = data.frame(
    inceptionDate = c("01/01/2006", "01/07/2006", "01/01/2007")
    ,expiryDate = c("31/12/2006", "30/06/2007", "31/12/2007")
)

Dates$inceptionDate<-as.POSIXct(Dates$inceptionDate, format="\%d/\%m/\%Y")

Dates$expiryDate<-as.POSIXct(Dates$expiryDate, format="\%d/\%m/\%Y")

ValuationDate<-as.POSIXct("30/10/2007", format="\%d/\%m/\%Y")

PureIBNRLNorm(Dates$inceptionDate,Dates$expiryDate,ValuationDate,4,1.5)
}
