% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawregimeraw.R
\name{drawRegimeRaw}
\alias{drawRegimeRaw}
\title{Plot of network by hidden regime}
\usage{
drawRegimeRaw(mcmcout, Y)
}
\arguments{
\item{mcmcout}{NetworkChange output}

\item{Y}{Input raw data}
}
\value{
A plot object
}
\description{
Plot latent node cluster
}
\examples{

   \dontrun{
   set.seed(1973)
   ## generate an array with two constant blocks
   data(MajorAlly)
   Y <- MajorAlly
   fit <- NetworkChange(newY, R=2, m=2, mcmc=G, initial.s = initial.s,
          burnin=G, verbose=0, v0=v0, v1=v1)
   drawRegimeRaw(fit, newY)
   }
}
\references{
Jong Hee Park and Yunkyun Sohn. 2019. "Detecting Structural Change
in Longitudinal Network Data." \emph{Bayesian Analysis}. Forthcoming.
}
