% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{PMFG}
\alias{PMFG}
\title{Planar Maximally Filtered Graph}
\usage{
PMFG(data, normal = FALSE, weighted = TRUE, na.data = c("pairwise",
  "listwise", "fiml"), progBar = TRUE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{weighted}{Should network be weighted?
Defaults to TRUE.
Set to FALSE to produce an unweighted (binary) network}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
If normal is TRUE, then "pairwise" is used.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}
}
\value{
Returns a PMFG-filtered associaton matrix
}
\description{
Applies the Planar Maximally Filtered Graph (PMFG) filtering method
(see and cite Tumminello et al., 2005).
Currently very slow! (efficiency updates soon to come)
}
\examples{
\dontrun{
weighted_PMFGnetwork<-PMFG(hex)
}
}
\references{
Tumminello, M., Aste, T., Di Matteo, T., & Mantegna, R. N. (2005).
A tool for filtering information in complex systems.
\emph{Proceedings of the National Academy of Sciences}, \emph{102}(30), 10421-10426.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
