% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depend.R
\name{depend}
\alias{depend}
\title{Dependency Network Approach}
\usage{
depend(
  data,
  normal = FALSE,
  na.data = c("pairwise", "listwise", "fiml", "none"),
  index = FALSE,
  fisher = FALSE,
  progBar = TRUE
)
}
\arguments{
\item{data}{A set of data}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to \code{FALSE}. Data is not transformed to be normal.
Set to \code{TRUE} if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For \code{"listwise"} deletion the \code{\link{na.omit}} function is applied.
Set to \code{"fiml"} for Full Information Maximum Likelihood (\link[psych]{corFiml}).
Full Information Maximum Likelihood is \strong{recommended} but time consuming}

\item{index}{Should correlation with the latent variable
(i.e., weighted average of all variables) be removed?
Defaults to \code{FALSE}.
Set to \code{TRUE} to remove common latent factor}

\item{fisher}{Should Fisher's Z-test be used to keep significantly higher influences (index only)?
Defaults to \code{FALSE}.
Set to \code{TRUE} to remove non-significant influences}

\item{progBar}{Should progress bar be displayed?
Defaults to \code{TRUE}.
Set to \code{FALSE} for no progress bar}
}
\value{
Returns an adjacency matrix of dependencies
}
\description{
Generates a dependency matrix of the data (index argument is still in testing phase)
}
\examples{
\dontrun{
D <- depend(neoOpen)

Dindex <- depend(neoOpen, index = TRUE)
}
}
\references{
Kenett, D. Y., Tumminello, M., Madi, A., Gur-Gershgoren, G., Mantegna, R. N., & Ben-Jacob, E. (2010).
Dominating clasp of the financial sector revealed by partial correlation analysis of the stock market.
\emph{PLoS one}, \emph{5}, e15032.

Kenett, D. Y., Huang, X., Vodenska, I., Havlin, S., & Stanley, H. E. (2015).
Partial correlation analysis: Applications for financial markets.
\emph{Quantitative Finance}, \emph{15}, 569-578.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
