% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/management.R
\name{calc_man_ess}
\alias{calc_man_ess}
\title{Calculate the 'performance' of sustainable soil management given a required ecosystem service}
\usage{
calc_man_ess(
  A_SOM_LOI,
  B_LU_BRP,
  B_SOILTYPE_AGR,
  B_GWL_CLASS,
  D_SOM_BAL,
  D_CP_GRASS,
  D_CP_POTATO,
  D_CP_RUST,
  D_CP_RUSTDEEP,
  D_GA,
  M_COMPOST,
  M_GREEN,
  M_NONBARE,
  M_EARLYCROP,
  M_SLEEPHOSE,
  M_DRAIN,
  M_DITCH,
  M_UNDERSEED,
  M_LIME,
  M_NONINVTILL,
  M_SSPM,
  M_SOLIDMANURE,
  M_STRAWRESIDUE,
  M_MECHWEEDS,
  M_PESTICIDES_DST,
  type
)
}
\arguments{
\item{A_SOM_LOI}{(numeric) The percentage organic matter in the soil (\%)}

\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{B_GWL_CLASS}{(character) The groundwater table class}

\item{D_SOM_BAL}{(numeric) The organic matter balance of the soil (in kg EOS per ha)}

\item{D_CP_GRASS}{(numeric) The fraction grassland in crop rotation}

\item{D_CP_POTATO}{(numeric) The fraction potato crops in crop rotation}

\item{D_CP_RUST}{(numeric) The fraction rustgewassen in crop rotation}

\item{D_CP_RUSTDEEP}{(numeric) The fraction diepe rustgewassen in crop rotation (-)}

\item{D_GA}{(numeric) The age of the grassland (years)}

\item{M_COMPOST}{(numeric) The frequency that compost is applied (optional, every x years)}

\item{M_GREEN}{(boolean) measure. are catch crops sown after main crop (option: yes or no)}

\item{M_NONBARE}{(boolean) measure. is parcel for 80 percent of the year cultivated and 'green' (option: yes or no)}

\item{M_EARLYCROP}{(boolean) measure. use of early crop varieties to avoid late harvesting (option: yes or no)}

\item{M_SLEEPHOSE}{(boolean) measure. is sleepslangbemester used for slurry application (option: yes or no)}

\item{M_DRAIN}{(boolean) measure. are under water drains installed in peaty soils (option: yes or no)}

\item{M_DITCH}{(boolean) measure. are ditched maintained carefully and slib applied on the land (option: yes or no)}

\item{M_UNDERSEED}{(boolean) measure. is maize grown with grass underseeded (option: yes or no)}

\item{M_LIME}{(boolean) measure. Has field been limed in last three years (option: yes or no)}

\item{M_NONINVTILL}{(boolean) measure. Non inversion tillage (option: yes or no)}

\item{M_SSPM}{(boolean) measure. Soil Structure Protection Measures, such as fixed driving lines, low pressure tires, and light weighted machinery (option: yes or no)}

\item{M_SOLIDMANURE}{(boolean) measure. Use of solid manure (option: yes or no)}

\item{M_STRAWRESIDUE}{(boolean) measure. Application of straw residues (option: yes or no)}

\item{M_MECHWEEDS}{(boolean) measure. Use of mechanical weed protection (option: yes or no)}

\item{M_PESTICIDES_DST}{(boolean) measure. Use of DST for pesticides (option: yes or no)}

\item{type}{(character) type of ecosystem service to evaluate the impact of soil management. Options: I_M_SOILFERTILITY, I_M_CLIMATE, I_M_WATERQUALITY, and I_M_BIODIVERSITY}
}
\value{
The evaluated soil management score for multiple soil ecosystem services.
This is done for the following ESS: I_M_SOILFERTILITY, I_M_CLIMATE, I_M_WATERQUALITY and I_M_BIODIVERSITY
}
\description{
This function evaluates the contribution of sustainable soil management for a given ecosystem service
}
\examples{
calc_man_ess(A_SOM_LOI = 4.5,B_LU_BRP = 3732, B_SOILTYPE_AGR = 'dekzand',
B_GWL_CLASS = 'IV',D_SOM_BAL = 1115,D_CP_GRASS = 0.2,D_CP_POTATO = 0.5,
D_CP_RUST = 0.3,D_CP_RUSTDEEP = 0.2,D_GA = 0,M_COMPOST = rep(25,1),
M_GREEN = TRUE, M_NONBARE = TRUE, M_EARLYCROP = TRUE, M_SLEEPHOSE = TRUE, 
M_DRAIN = TRUE, M_DITCH = TRUE, M_UNDERSEED = TRUE,M_LIME = TRUE, 
M_NONINVTILL = TRUE, M_SSPM = TRUE, M_SOLIDMANURE = TRUE,M_STRAWRESIDUE = TRUE,
M_MECHWEEDS = TRUE,M_PESTICIDES_DST = TRUE,type="I_M_SOILFERTILITY")
}
