% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_cut_node.R
\name{best.cut.node}
\alias{best.cut.node}
\title{find best splitting variable and node}
\usage{
best.cut.node(
  X,
  y,
  split,
  lambda = "log",
  weights = 1,
  MinLeaf = 10,
  numLabels = ifelse(split == "mse", 0, length(unique(y)))
)
}
\arguments{
\item{X}{An n by d numeric matrix (preferable) or data frame.}

\item{y}{A response vector of length n.}

\item{split}{One of three criteria, 'gini': gini impurity index (classification), 'entropy': information gain (classification)
or 'mse': mean square error (regression).}

\item{lambda}{The adjustment parameter of \code{split} is used to determine whether to split or not, with the available values being 0, 1 and 'log' (Default).}

\item{weights}{A vector of values which weigh the samples when considering a split.}

\item{MinLeaf}{Minimal node size (Default 10).}

\item{numLabels}{The number of categories.}
}
\value{
A list which contains:
\itemize{
\item BestCutVar: The best split variable.
\item BestCutVal: The best split points for the best split variable.
\item BestIndex: Each variable corresponds to the min gini impurity index, the max information gain or the min mean square error.
}
}
\description{
A function to select the splitting variables and nodes using one of three criteria.
}
\examples{
### Find the best split variable ###
data(iris)
X <- as.matrix(iris[, 1:4])
y <- iris[[5]]
bestcut <- best.cut.node(X, y, split = "gini")
print(bestcut)

}
