% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvplot.OEFPIL.R
\name{curvplot.OEFPIL}
\alias{curvplot.OEFPIL}
\title{Plot of estimated curve for OEFPIL object}
\usage{
curvplot.OEFPIL(object, signif.level, xx)
}
\arguments{
\item{object}{an object of class \code{"OEFPIL"} (a result of a call to \code{\link{OEFPIL}}).}

\item{signif.level}{a numeric value or a vector of significance levels for pointwise confidence bands. If missing, the estimated curve is plotted without confidence bands.}

\item{xx}{a sequence of x-coordinates of points for computing and plotting confidence bands. If missing, the default sequence \code{seq(from = min(x), to = max(x), length.out = 301)} is used.}
}
\value{
A ggplot graph of the estimated curve with pointwise confidence bands. The result can be edit using other ggplot components as usually.
}
\description{
Function for plotting the estimated curve with pointwise confidence bands for an object of class \code{"OEFPIL"}.
}
\examples{
library(MASS)
library(ggplot2)

##Creating a data file
steamdata <- steam
colnames(steamdata) <- c("x","y")
n <- nrow(steamdata)
CM1 <- diag(rep(10,2*n))
CM2 <- diag(c(rep(12,n), rep(14,n)))

##Creating OEFPIL objects
st1 <- OEFPIL(steamdata, y ~ b1 * 10^(b2 * x/ (b3 + x)), list(b1 = 5, b2 = 8, b3 = 200),
             CM1, useNLS = FALSE)
st2 <- OEFPIL(steamdata, y ~ b1 * 10^(b2 * x/ (b3 + x)), list(b1 = 5, b2 = 8, b3 = 200),
             CM2, useNLS = FALSE)

##Use of curvplot.OEFPIL function on an object of class 'OEFPIL'
curvplot.OEFPIL(st1, signif.level = 0.05)

##Use of curvplot.OEFPIL function on an object of class 'OEFPIL' with different arguments
curvplot.OEFPIL(st2, signif.level = c(0.01,0.05), xx = seq(0,110,1))

##Use of curvplot.OEFPIL function with additional arguments as for ggplot2
curvplot.OEFPIL(st1, signif.level = 0.05) +
 labs(x = "New x label") +
 labs(title = "New graph title")

}
\seealso{
\code{\link{OEFPIL}}, \code{\link{paramplot.OEFPIL}} and \code{\link{plot.OEFPIL}}.
}
