% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{gen.data}
\alias{gen.data}
\title{generate data}
\usage{
gen.data(
  Sample_T,
  p1,
  p2,
  k1,
  k2,
  tau = 0.5,
  change = 0,
  pp = 0.3,
  a = 0,
  cc = 0
)
}
\arguments{
\item{Sample_T}{positive integer indicating the length of series.}

\item{p1}{positive integer indicating the row dimension.}

\item{p2}{positive integer indicating the column dimension.}

\item{k1}{positive integer indicating the number of row factors.}

\item{k2}{positive integer indicating the number of column factors.}

\item{tau}{a real number in \eqn{(0,1)}, indicating the location of change
point, i.e., (\eqn{\tau T}).}

\item{change}{the type of change, taking 0 for no change point, taking 1 for
the case that the loading matrix \bold{R} changes, taking other values for the case
that a new row factor occurs.}

\item{pp}{a number in \eqn{(0,1]}, indicating the magnitude of the break.
When \eqn{change=1}, \emph{pp} is the proportion of entries in \bold{R} that changes;
when \emph{change} is not equal to 0 or 1, \emph{pp} is the proportion of non-zero entries in the new factor
loading.}

\item{a}{a number in \eqn{[0,min(p_1,p_2))}, indicating the
cross-sectional correlations of the idiosyncratic errors.}

\item{cc}{a number in \eqn{[0,1)}, indicating the AR(1) coefficient of the
factor and error processes.}
}
\value{
a \eqn{T\times p1 \times p2} array.
}
\description{
This function generates matrix-valued time series under a two-way factor
structure with/without a change point.
}
\details{
See the paper He et al. (2021).
}
\examples{
# set parameters
k1=3
k2=3
epsilon=0.05
Sample_T=50
p1=40
p2=20


# generate data
Y=gen.data(Sample_T,p1,p2,k1,k2,tau=0.5,change=1,pp=0.3)
print("the dimension of Y is:")
print(dim(Y))

}
\references{
He Y, Kong X, Trapani L, & Yu L(2021). Online change-point
detection for matrix-valued time series with latent two-way factor
structure. \emph{arXiv preprint}, arXiv:2112.13479.
}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
