% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simexpr}
\alias{simexpr}
\title{Simulated data with differentially expressed (DE) genes}
\format{
A dataframe with 1000 rows and 62 variables:
\describe{
  \item{DEgen}{It indicates whether gene \code{g} is DE or not.}
  \item{gap}{It contains \eqn{\Delta} values.}
  \item{A1-A30}{These columns have the expression levels under experimental condition 1.}
  \item{B1-B30}{These columns have the expression levels under experimental condition 2.}
}
}
\usage{
simexpr
}
\description{
Simulated data with 1000 genes measured under two different 
experimental conditions 1 and 2. 100 genes among the 1000 were generated as 
differentially expressed (DE) genes. The expression levels of all no DE genes 
were generated by \eqn{N(0,1)} distribution in both conditions 1 and 2. 
The DE genes were generated using the \eqn{N(0,1)} and \eqn{N(\mu_g,1)} distributions
for conditions 1 and 2, respectively, with \eqn{|\mu_g|=\Delta}.
Parameter \eqn{\Delta} sets the importance of gene \code{g}, where the bigger \eqn{\Delta} is,
the more important gene \code{g} is. We considered \eqn{\Delta} in \eqn{\{1.5, 2, 3\}}.
Each row \eqn{g} in \code{simexpr} corresponds to a simulated gene.
}
\keyword{datasets}
