% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkLL.R
\name{checkLL}
\alias{checkLL}
\title{lat-long coordinate check}
\usage{
checkLL(lat = 0, long = 0, fun = stop, trace = TRUE, ...)
}
\arguments{
\item{lat, long}{lat or long values. DEFAULT: NA}

\item{fun}{One of the functions \code{\link{stop}}, \code{\link{warning}}, or \code{\link{message}}. DEFAULT: stop}

\item{trace}{Logical: Add function call stack to the message? DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{fun}}
}
\value{
Invisible T/F vector showing which of the coordinates is violated
        in the order: minlat, maxlat, minlong, maxlong.
        Only returned if check is passed or fun != stop
}
\description{
check lat-long coordinates for plausibility
}
\examples{
checkLL(lat=52, long=130)
checkLL(130, 52, fun=message)
checkLL(85:95, fun=message)

\dontrun{
checkLL(85:95, fun="message")
checkLL(170,35) # throws an informative error
checkLL(85:95, trace=FALSE)
checkLL(,100:200) # can handle vectors
}

mustfail <- function(expr) stopifnot(berryFunctions::is.error(expr))
mustfail( checkLL(100)         )
mustfail( checkLL(100, 200)    )
mustfail( checkLL(-100, 200)   )
mustfail( checkLL(90.000001)   )

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2016
}
\seealso{
\code{\link{pointsMap}}, \code{\link{putm}},
         \code{berryFunctions::\link[berryFunctions]{checkFile}}
}

