% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{ensemble}
\alias{ensemble}
\title{Generate an ensemble of partitions.}
\usage{
ensemble(data, nbs, clust_param, clustering = "kmeans",
  perturb_method = 1)
}
\arguments{
\item{data}{-- data that will be perturbed.}

\item{nbs}{-- the number of clustering partitions to be generated.}

\item{clust_param}{-- parameters for pre-defined clustering methods. If clustering is "kmeans", "Mclust", "hclust", this is an integer indicating the number of clusters. For "dbscan", a numeric indicating epsilon. For "HMM-VB", a list of parameters.}

\item{clustering}{-- baseline clustering methods. User specified functions or example methods included in package ("kmeans", "Mclust", "hclust", "dbscan", "PCAreduce", "HMM-VB") can be used. Refer to the Detail.}

\item{perturb_method}{-- adding noise is \code{0} and bootstrap resampling is \code{1}. Default is bootstrap resampling.
# perturb_method=0 perturbed by adding Gaussian noise.}
}
\value{
a matrix of cluster labels of the ensemble partitions. Each column is cluster labels of an individual clustering result.
}
\description{
Generate multiple clustering results (that is, partitions) based on multiple versions of perturbed data using a specified baseline clustering method.
}
\examples{
data(sim1)
# the number of clusters.
C = 4
ens.data = ensemble(sim1$X[1:10,], nbs=10, clust_param=C, clustering="kmeans", perturb_method=1)
}
