% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{distcenter}
\alias{distcenter}
\title{A function to compute the distance from spatial units centroids
to the center}
\usage{
distcenter(spatobj = NULL, folder = NULL, shape = NULL, center = 1)
}
\arguments{
\item{spatobj}{- a Spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}

\item{center}{- the row number of the center}
}
\value{
A vector with the distance to the center's centroid
}
\description{
The function is based on \pkg{rgdal} and \pkg{rgeos}
packages and it can be used by providing a shape file or a R
spatial object (SpatialPolygonsDataFrame).
}
\examples{
distcenter(GreHSize, center = 19)

foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'
distcenter(folder = foldername, shape = shapename, center = 19)
}
\seealso{
Other spatial functions used for segregation indices
computation: \code{\link{area}}, \code{\link{contig}},
\code{\link{perimeter}}, \code{\link{distance}},
\code{\link{boundaries}}, \code{\link{xgeo}}
}

