% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{rankorderseg}
\alias{rankorderseg}
\title{A function to compute rank-ordered segregation indices}
\usage{
rankorderseg(x, polorder = 4, pred = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group. The rows
represent the nominal categories (spatial units) and the columns the population
distribution as ordered groups divided by thresholds}

\item{polorder}{- order of the polynomial approximation (4 by default)}

\item{pred}{- a numerical vector with percentiles to be predicted. 
If NULL, the predictions are made at threshold levels}
}
\value{
A list containing the results for three rank-ordered indices: 
rank-order information theory index (Hr), rank-order variation ratio 
index (Rr) and rank-order square root index (Sr). For each index, a sublist 
is provided, containing: 
Index - the rank-ordered index value
Hp/Rp/Sp - a vector with ordinal information theory/variance ratio/square root 
segregation index values at thresholds
Coefficients - Coefficients extracted from the polynomial estimation model,
including basic statistics
Predict - a list contining predicted values of the coresponding ordinal index (fit); 
standard error of predicted means (se.fit); degrees of freedom for residual (df); 
and residual standard deviations (residuale.scale). If pred is NULL, the function 
will return the the statistics at thresholds
}
\description{
A function computing Reardon (2011) rank-ordered 
segregation indices
}
\examples{
x1 <- matrix(nrow = 4, ncol = 7)
x1[1,] <- c( 10,  10, 10, 20, 30, 40, 50)
x1[2,] <- c( 0, 20, 10, 10, 10, 20, 20)
x1[3,] <- c(10, 20,  10, 10, 10, 0, 0 )
x1[4,] <- c(30, 30,  20, 10, 10, 0, 0 )
x2 <- x1
x2[,c(3,4,6,7)] <- x1[,c(6,7,3,4)]

rankorderseg(x1)
rankorderseg(x2, pred = seq(0, 1, 0.1))

}
\references{
Reardon S. F. (2011) \emph{Measures of Income Segregation
}. The Stanford Center on Poverty and Inequality
}
\seealso{
\code{\link{ordinalseg}}
}
