% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{HTheil}
\alias{HTheil}
\title{A function to compute Theil's entropy segregation index}
\usage{
HTheil (x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
a numeric vector containing Theils's entropy index value for 
each group
}
\description{
The entropy index (also called information index) measures
departure from evenness by assessing each spatial unit deviation from the 
entropy in the area.
}
\examples{
x <- segdata@data[ ,1:2]
HTheil(x) 
}
\references{
Theil H. (1972)  \emph{Statistical decomposition analysis: with 
applications in the social and administrative.} Amsterdam, North-Holland, 337 p.
}
\seealso{
One-group evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Gini}}, \code{\link{Gorard}}, 
\code{\link{Atkinson}}, '\code{\link{ISWong}}, \code{\link{ISMorrill}},
\code{\link{ISMorrillK}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{Gini2}}, 
\code{\link{DIMorrill}}, \code{\link{DIMorrillK}}, \code{\link{DIWong}}
}
