/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.generator;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.andwellness.xml.datagenerator.generator.MobilityMessageGenerator;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.json.JSONException;

public class MobilityModeOnlyJsonMessageGenerator
implements MobilityMessageGenerator {
    private Date date;
    private double latitude;
    private double longitude;

    @Override
    public Map<String, Object> createMessage(Date date) throws JSONException {
        this.date = date;
        this.latitude = ValueCreator.latitude();
        this.longitude = ValueCreator.longitude();
        return this.generateJSON();
    }

    @Override
    public Map<String, Object> createMessage(Date date, double maxLon, double minLon, double maxLat, double minLat) throws JSONException {
        this.date = date;
        this.latitude = ValueCreator.latitude(maxLat, minLat);
        this.longitude = ValueCreator.longitude(maxLon, minLon);
        return this.generateJSON();
    }

    public Map<String, Object> generateJSON() throws JSONException {
        String tz = ValueCreator.tz();
        String subtype = "mode_only";
        String dateString = ValueCreator.date(this.date);
        String mode = ValueCreator.mode();
        long epoch = ValueCreator.epoch(this.date);
        String locationStatus = ValueCreator.randomLocationStatus();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", epoch);
        map.put("timezone", tz);
        map.put("subtype", subtype);
        map.put("mode", mode);
        map.put("location_status", locationStatus);
        if (!"unavailable".equals(locationStatus)) {
            HashMap<String, Object> location = new HashMap<String, Object>();
            location.put("latitude", this.latitude);
            location.put("longitude", this.longitude);
            location.put("accuracy", Float.valueOf(ValueCreator.randomPositiveFloat()));
            location.put("provider", ValueCreator.randomProvider());
            location.put("timestamp", dateString);
            map.put("location", location);
        }
        return map;
    }
}

