/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.generator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.andwellness.xml.datagenerator.generator.MobilityMessageGenerator;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.json.JSONException;

public class MobilityModeExtendedJsonMessageGenerator
implements MobilityMessageGenerator {
    private Date date;
    private double latitude;
    private double longitude;

    @Override
    public Map<String, Object> createMessage(Date date) throws JSONException {
        this.date = date;
        this.latitude = ValueCreator.latitude();
        this.longitude = ValueCreator.longitude();
        return this.generateJSON();
    }

    @Override
    public Map<String, Object> createMessage(Date date, double maxLon, double minLon, double maxLat, double minLat) throws JSONException {
        this.date = date;
        this.latitude = ValueCreator.latitude(maxLat, minLat);
        this.longitude = ValueCreator.longitude(maxLon, minLon);
        return this.generateJSON();
    }

    private Map<String, Object> generateJSON() {
        int j;
        String tz = "PST";
        String subtype = "sensor_data";
        long epoch = ValueCreator.epoch(this.date);
        String locationStatus = ValueCreator.randomLocationStatus();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", UUID.randomUUID());
        map.put("time", epoch);
        map.put("timezone", tz);
        map.put("subtype", subtype);
        map.put("location_status", locationStatus);
        if (!"unavailable".equals(locationStatus)) {
            HashMap<String, Object> location = new HashMap<String, Object>();
            location.put("latitude", this.latitude);
            location.put("longitude", this.longitude);
            location.put("accuracy", Float.valueOf(ValueCreator.randomPositiveFloat()));
            location.put("provider", ValueCreator.randomProvider());
            location.put("time", epoch);
            location.put("timezone", tz);
            map.put("location", location);
        }
        HashMap<String, Object> sensorData = new HashMap<String, Object>();
        sensorData.put("speed", ValueCreator.randomPositiveDouble());
        String mode = ValueCreator.mode();
        if (!"error".equals(mode)) {
            ArrayList accelEntries = new ArrayList();
            int numberOfAccelEntries = ValueCreator.randomPositiveIntModulus(30) + 1;
            for (j = 0; j < numberOfAccelEntries; ++j) {
                HashMap<String, Double> points = new HashMap<String, Double>();
                points.put("x", ValueCreator.randomDouble());
                points.put("y", ValueCreator.randomDouble());
                points.put("z", ValueCreator.randomDouble());
                accelEntries.add(points);
            }
            sensorData.put("accel_data", accelEntries);
        }
        int numberOfWifiEntries = ValueCreator.randomPositiveIntModulus(20);
        ArrayList wifiScanEntries = new ArrayList();
        for (j = 0; j < numberOfWifiEntries; ++j) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("ssid", ValueCreator.randomMacAddress());
            int s = ValueCreator.randomPositiveIntModulus(120);
            entry.put("strength", -s);
            wifiScanEntries.add(entry);
        }
        HashMap<String, Object> wifiData = new HashMap<String, Object>();
        wifiData.put("scan", wifiScanEntries);
        wifiData.put("time", epoch);
        wifiData.put("timezone", tz);
        sensorData.put("wifi_data", wifiData);
        sensorData.put("mode", mode);
        map.put("data", sensorData);
        return map;
    }
}

