% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_n.R
\name{olink_normalization_sample_check}
\alias{olink_normalization_sample_check}
\title{An internal function to perform checks on the input samples in the functions
olink_normalization_bridge and olink_normalization_subset. The function is
expected to run all checks on SampleID to make sure that normalization can
be performed smoothly. It should work independently of the function calling
it.}
\usage{
olink_normalization_sample_check(
  list_samples,
  check_mode,
  project_1_all_samples,
  project_2_all_samples
)
}
\arguments{
\item{list_samples}{Named list of 2 arrays containing SampleID of the
subset or bridge samples to be used for normalization. The names of the two
arrays should be DF1 and DF2 corresponding to projects 1 and 2, respectively.
(required)}

\item{check_mode}{Flag "bridge" or "subset" indicating the type of
normalization the check should be tailored to (required)}

\item{project_1_all_samples}{Array of all samples from project 1 (required)}

\item{project_2_all_samples}{Array of all samples from project 2 (required)}
}
\value{
a character message. If the message is "TRUE" then all checks passed,
otherwise an error message will be printed.
}
\description{
An internal function to perform checks on the input samples in the functions
olink_normalization_bridge and olink_normalization_subset. The function is
expected to run all checks on SampleID to make sure that normalization can
be performed smoothly. It should work independently of the function calling
it.
}
