% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_mixed_model.R
\name{olink_lmer_plot}
\alias{olink_lmer_plot}
\title{Function which performs a point-range plot per protein on a linear mixed model}
\usage{
olink_lmer_plot(
  df,
  variable,
  outcome = "NPX",
  random,
  olinkid_list = NULL,
  covariates = NULL,
  x_axis_variable,
  col_variable = NULL,
  number_of_proteins_per_plot = 6,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{df}{NPX data frame in long format with at least protein name (Assay), OlinkID, UniProt, 1-2 variables with at least 2 levels.}

\item{variable}{Single character value or character array.
Variable(s) to test. If length > 1, the included variable names will be used in crossed analyses .
Also takes ':' or '*' notation.}

\item{outcome}{Character. The dependent variable. Default: NPX.}

\item{random}{Single character value or character array.}

\item{olinkid_list}{Character vector indicating which proteins (by OlinkID) for which to create figures.}

\item{covariates}{Single character value or character array. Default: NULL.
Covariates to include. Takes ':' or '*' notation. Crossed analysis will not be inferred from main effects.}

\item{x_axis_variable}{Character. Which main effect to use as x-axis in the plot.}

\item{col_variable}{Character. If provided, the interaction effect col_variable:x_axis_variable will be plotted with x_axis_variable on the x-axis and col_variable as color.}

\item{number_of_proteins_per_plot}{Number plots to include in the list of point-range plots. Defaults to 6 plots per figure}

\item{verbose}{Boolean. Default: True. If information about removed samples, factor conversion and final model formula is to be printed to the console.}

\item{...}{coloroption for color ordering}
}
\value{
A list of objects of class "ggplot" showing point-range plot of NPX (y-axis) over x_axis_variable for each assay (facet), colored by col_variable if provided.
}
\description{
Generates a point-range plot faceted by Assay using ggplot and ggplot2::geom_pointrange based on a linear mixed effects model using lmerTest:lmer and emmeans::emmeans.
See \code{olink_lmer} for details of input notation.
}
\examples{
\donttest{

library(dplyr)
if (requireNamespace("lme4", quietly = TRUE) & requireNamespace("lmerTest", quietly = TRUE)){
lmer_results <- olink_lmer(df = npx_data1,
                           variable=c("Time", 'Treatment'),
                           random = c('Subject'))

assay_list <- lmer_results \%>\%
    filter(Threshold == 'Significant' & term == 'Time:Treatment') \%>\%
    select(OlinkID) \%>\%
    distinct() \%>\%
    pull()

list_of_pointrange_plots <- olink_lmer_plot(df = npx_data1,
                                            variable=c("Time", 'Treatment'),
                                            random = c('Subject'),
                                            x_axis_variable = 'Time',
                                            col_variable = 'Treatment',
                                            verbose=TRUE,
                                            olinkid_list = assay_list,
                                            number_of_proteins_per_plot = 10)
}
}
}
