% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addBarcodes}
\alias{addBarcodes}
\title{Add barcode plot metadata}
\usage{
addBarcodes(study, barcodes, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{barcodes}{The metadata variables that describe the barcode plot.
The input object is a list of lists (one per model). Each sublist must
contain the element \code{statistic}, which is the column name in the
results table to use to construct the barcode plot. Each sublist may
additionally contain any of the following optional elements:
1) \code{absolute} - Should the statistic be converted to its absolute
value (default is \code{TRUE}).
2) \code{logFoldChange} - The column name in the results table that contains
the log fold change values.
3) \code{labelStat} - The x-axis label to describe the statistic.
4) \code{labelLow} - The left-side label to describe low values of the statistic.
5) \code{labelHigh} - The right-side label to describe high values of the statistic.
6) \code{featureDisplay} - The feature variable to use to label the barcode plot
on hover.
To share metadata across multiple models, use the modelID "default".}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
  \code{study}, but modified to include the newly added data
}
\description{
The app can display a barcode plot of the enrichment results for a given
annotation term. The metadata in `barcodes` instructs the app how to create
and label the barcode plot.
}
