% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{getPlottingData}
\alias{getPlottingData}
\title{Get plotting data}
\usage{
getPlottingData(study, modelID, featureID, libraries = NULL)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{featureID}{Filter by featureID}

\item{libraries}{The directories to search for installed study packages. If
left as \code{NULL} (the default), then
\code{\link[utils]{installed.packages}} will use the result of
\code{\link{.libPaths}}.}
}
\value{
Returns a list of 3 data frames:

\item{\code{assays}}{A data frame that contains the assay measurements,
filtered to only include the row(s) corresponding to the input featureID(s)
(see \code{\link{getAssays}}). If multiple featureIDs are requested, the rows
are reordered to match the order of this input. The column order is
unchanged.}

\item{\code{samples}}{A data frame that contains the sample metadata for the
given modelID (see \code{\link{getSamples}}). The rows are reordered to match
the columns of the assays data frame.}

\item{\code{features}}{A data frame that contains the feature metadata,
filtered to only include the row(s) corresponding to the input featureID(s)
(see \code{\link{getFeatures}}). If multiple featureIDs are requested, the
rows are reordered to match the order of this input (and thus match the order
of the assays data frame).}
}
\description{
This function creates the input data that \code{\link{plotStudy}} passes to
custom plotting functions added with \code{\link{addPlots}}. You can use it
directly when you are interactively creating your custom plotting functions.
}
\seealso{
\code{\link{addPlots}}, \code{\link{plotStudy}}
}
