% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_combo2.R
\docType{data}
\name{hist_combo2}
\alias{hist_combo2}
\title{Dataset: historical data on two single-agents to inform a combination study}
\format{A data frame with 11 rows and 5 variables:
\describe{
  \item{group_id}{study}
  \item{DosesAdm1}{dose of Drug A}
  \item{DosesAdm2}{dose of Drug B}
  \item{Npat}{number of patients}
  \item{Ntox}{number of DLTs}
}}
\usage{
hist_combo2
}
\description{
One of two datasets from the application described in Neuenschwander et al 
(2016). The risk of DLT is to be studied as a function of dose for two drugs, 
drug A and drug B. Historical information on the toxicity profiles of these 
two drugs is available from single agent trials \code{trial_A} and \code{trial_B}. 
A second dataset \code{codata_combo2} is available from this application, 
which includes additional dose-toxicity data from \code{trial_AB} and \code{IIT} of the
combination of Drugs A and B.
}
\references{
Neuenschwander, B., Roychoudhury, S., & Schmidli, H. 
 (2016). On the use of co-data in clinical trials. \emph{Statistics in 
 Biopharmaceutical Research}, 8(3), 345-354.
}
\keyword{datasets}
