% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{query_mongodb_api}
\alias{query_mongodb_api}
\title{Query a mongoDB database}
\usage{
query_mongodb_api(collection, database, dataSource, apiKey_env_var, objectId)
}
\arguments{
\item{collection}{The name of the MongoDB collection to query.}

\item{database}{The name of the MongoDB database.}

\item{dataSource}{The data source information.}

\item{apiKey_env_var}{The API key for authentication}

\item{objectId}{The object ID for the findOne operation.}
}
\value{
A result containing the outcome of the findOne operation.
}
\description{
This function queries a mongodb database by specifying the collection, database, data source, API key, and objectID.
}
\examples{
\dontrun{
Sys.setenv("MONGODB_API_KEY" = 'your_mongodb_api_key')
objectId <- 'example_object_id'
result <- query_mongodb_api(
  collection = 'your_mongodb_collection',
  database = 'your_database',
  dataSource = 'your_dataSource',
  apiKey_env_var = "MONGODB_API_KEY",
  objectId = objectId
)
print(result)
}
}
