% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hog_features_rscript.R
\name{HOG_apply}
\alias{HOG_apply}
\title{calculate the HOG (Histogram of oriented gradients) for a matrix, array or a folder of images}
\usage{
HOG_apply(object, cells = 3, orientations = 6, rows = NULL,
  columns = NULL, threads = 1)
}
\arguments{
\item{object}{a matrix, a data frame, a 3-dimensional array or a path to a folder of files (images)}

\item{cells}{the number of divisions ( cells )}

\item{orientations}{number of orientation bins}

\item{rows}{a value specifying the number of rows of each image-row of the matrix (required if object is a matrix)}

\item{columns}{a value specifying the number of columns of each image-row of the matrix (required if object is a matrix)}

\item{threads}{the number of parallel cores to use}
}
\value{
If the input is a matrix, data frame or array it returns a matrix of the hog descriptors. If the input is a path to a folder it returns a list of length 2, 
the 1st sublist is a vector with the names of the image files (the order of the files in the vector corresponds to the order of the rows of the output matrix),
the 2nd sublist is the matrix of the hog descriptors.
}
\description{
calculate the HOG (Histogram of oriented gradients) for a matrix, array or a folder of images
}
\details{
This function takes as input either a matrix, a data frame, a 3-dimensional array or a character path to a folder of files (images). It returns the HOG-descriptors 
(histogram of oriented gradients) for each row (if matrix or data frame), for each array-slice (if array) or for each file (if path to a folder of images).
}
\examples{

MATR = matrix(runif(75), ncol = 25, nrow = 5)

res = HOG_apply(MATR, cells = 3, orientations = 5, rows = 5, columns = 5, threads = 1)


ARRAY = array(5, dim = c(10, 10, 3))

res = HOG_apply(ARRAY, cells = 3, orientations = 6, threads = 1)


FOLDER_path = paste0(system.file("tmp_images", "same_type", package = "OpenImageR"), '/')

res = HOG_apply(FOLDER_path, cells = 3, orientations = 6, threads = 1)

}

