% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listOMLDataSetQualities.R
\name{listOMLDataSetQualities}
\alias{listOMLDataSetQualities}
\title{List available OpenML qualities names.}
\usage{
listOMLDataSetQualities(verbosity = NULL)
}
\arguments{
\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{data.frame}].
}
\description{
The returned \code{data.frame} contains quality name \dQuote{name}.
}
\note{
This function is memoised. I.e., if you call this function twice in a running R session,
the first call will query the server and store the results in memory while the second and all subsequent calls will return
the cached results from the first call.
You can reset the cache by calling \code{\link[memoise]{forget}} on the function manually.
}
\examples{
\dontrun{
	listOMLDataSetQualities()
}
}
\seealso{
Other listing functions: \code{\link{listOMLDataSets}},
  \code{\link{listOMLEstimationProcedures}},
  \code{\link{listOMLEvaluationMeasures}},
  \code{\link{listOMLFlows}}, \code{\link{listOMLRuns}},
  \code{\link{listOMLTaskTypes}},
  \code{\link{listOMLTasks}}
}
