#
#   Copyright 2007-2018 The OpenMx Project
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
# 
#        http://www.apache.org/licenses/LICENSE-2.0
# 
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.


library(OpenMx)

pdat <- data.frame(length=c(1,2), ID=1L:2L, parentID=1L:2L)

m1 <- mxModel("slug", type="RAM",
              manifestVars = c("length"),
              mxData(type="raw", observed=pdat, primaryKey = 'ID'),
              mxPath("one", "length"),
              mxPath("length", arrows=2, values=1),
              mxPath("slug.length", "length", joinKey='parentID', labels="fromParent"))

omxCheckError(mxRun(m1), "slug.expectation cycle detected: 'slug.data' row 1 joins against itself")

