% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-calculate.R
\name{network_graph_images}
\alias{network_graph_images}
\title{Build network graph plots}
\usage{
network_graph_images(
  x,
  min_clique_size = 3,
  show_edges = TRUE,
  min_matches = 6,
  label_wrap_width = 15,
  label_max_length = -1,
  indicate_direction = TRUE,
  colorize_direction = TRUE,
  seed = 0
)
}
\arguments{
\item{x}{A dataframe with a grid.}

\item{min_clique_size}{Minimal size of cliques to be considered.}

\item{show_edges}{Whether to show edges in plot.}

\item{min_matches}{Minimal number of matching scores between constructs to be
marked as related.}

\item{label_wrap_width}{Width of wrapped element label text.}

\item{label_max_length}{Trim element label at max length characters.}

\item{indicate_direction, colorize_direction}{Indicate direction of
relatedness by \code{+/-} sign and edge color respectively.}

\item{seed}{Seed number passed to \code{set.seed}. Will determine the 
orientiation of the graph.}
}
\description{
Detects maximal cliques and saves images of network graphs into tempfile.
Tempfile paths and info on cliques are returned.
}
