/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import java.util.HashMap;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.StamenTileSource;

public class RTileController
extends TileController {
    public static HashMap<String, RTileController> map;
    public static TileSource[] sources;

    public RTileController(TileSource tileSource, TileCache tileCache, TileLoaderListener tileLoaderListener) {
        super(tileSource, tileCache, tileLoaderListener);
        this.tileSource = tileSource;
    }

    public static RTileController getInstance(String string) {
        String string2;
        RTileController rTileController;
        if (string.equals("bing")) {
            string = "Bing Aerial Maps";
        }
        if (map == null) {
            map = new HashMap();
            sources = new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.MapnikBw(), new OsmTileSource.MapToolKitTopo(), new OsmTileSource.Waze(), new MapQuestTileSource(), new MapQuestAerialTileSource(), new BingAerialTileSource(), new StamenTileSource.Toner(), new StamenTileSource.Terrain(), new StamenTileSource.WaterColor(), new OsmTileSource.MapnikGerman(), new OsmTileSource.Wanderreitkarte(), new OsmTileSource.MapBox(), new OsmTileSource.Esri(), new OsmTileSource.EsriTopo(), new OsmTileSource.Nps(), new OsmTileSource.Apple(), new OsmTileSource.Skobbler(), new OsmTileSource.CloudMade("2"), new OsmTileSource.CloudMade("999"), new OsmTileSource.CloudMade("998"), new OsmTileSource.CloudMade("7"), new OsmTileSource.CloudMade("1960"), new OsmTileSource.CloudMade("1155"), new OsmTileSource.CloudMade("12284"), new OsmTileSource.HillShade(), new OsmTileSource.CycleMap(), new OsmTileSource.BBBikeGerman(), new OsmTileSource.BBBike(), new OsmTileSource.PublicTransport(), new OsmTileSource.Transport()};
        }
        if ((rTileController = map.get(string)) != null) {
            return rTileController;
        }
        OsmTileSource.CloudMade cloudMade = null;
        if (string.startsWith("cloudmade")) {
            string2 = string.split("-")[1];
            cloudMade = new OsmTileSource.CloudMade(string2);
        } else {
            for (int i = 0; i < sources.length; ++i) {
                if (!sources[i].getName().equals(string)) continue;
                cloudMade = sources[i];
                break;
            }
        }
        if (cloudMade == null) {
            return null;
        }
        string2 = new MemoryTileCache();
        rTileController = new RTileController((TileSource)cloudMade, (TileCache)string2, new TileLoaderListener((MemoryTileCache)string2){
            final /* synthetic */ MemoryTileCache val$tc1;
            {
                this.val$tc1 = memoryTileCache;
            }

            public TileCache getTileCache() {
                return this.val$tc1;
            }

            public void tileLoadingFinished(Tile tile, boolean bl) {
            }
        });
        map.put(string, rTileController);
        return rTileController;
    }

    public Tile getTile(int n, int n2, int n3) {
        int n4 = 1 << n3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.tileLoader.createTileLoaderJob(this.tileSource, n, n2, n3).run();
        }
        return tile;
    }

    public int[] getTileValues(double d, double d2, double d3) {
        try {
            int[] nArray = new int[]{};
            Tile tile = this.getTile((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3));
            return tile.getImage().getRGB(0, 0, 255, 255, null, 0, 255);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static double[] getTileBBox(double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        int n = (int)Math.round(d);
        int n2 = (int)Math.round(d2);
        int n3 = (int)Math.round(d3);
        dArray[0] = OsmMercator.XToLon((int)n, (int)n3);
        dArray[2] = OsmMercator.XToLon((int)(n + 1), (int)n3);
        dArray[1] = OsmMercator.YToLat((int)n2, (int)n3);
        dArray[3] = OsmMercator.YToLat((int)(n2 + 1), (int)n3);
        return dArray;
    }

    public static void setCloudMadeKey(String string) {
        OsmTileSource.cloudMadeKey = string;
    }
}

