\name{OptSig.F}
\alias{OptSig.F}

\title{
Optimal Significance Level for an F-test
}
\description{
The function calculates the optimal level of significance for an F-test 
}
\usage{
OptSig.F(df1, df2, ncp, p = 0.5, k = 1, Figure = TRUE)
}

\arguments{
  \item{df1}{ the first degrees of freedom for the F-distribution}
  \item{df2}{ the second degrees of freedom for the F-distribution}
  \item{ncp}{ a value of of the non-centality paramter}
  \item{p}{ prior probability for H0, default is p = 0.5}
  \item{k}{ relative loss from Type I and II errors, k = L2/L1, default is k = 1}
  \item{Figure}{ show graph if TRUE (default); No graph if FALSE }
 }
\details{
See Kim and Choi (2019) 
}
\value{
\item{alpha.opt }{Optimal level of significance}
\item{crit.opt }{Critical value at the optimal level}
\item{beta.opt }{Type II error probability at the optimal level}
}
\references{
Kim and Choi, 2019, Choosing the Level of Significance: A Decision-theoretic Approach: Abacus: a Journal of Accounting, Finance and Business Studies. Wiley. 
}
\author{
Jae. H Kim
}
\note{
Applicable to any F-test, following F-distribution

The black curve in the figure is the line of enlightened judgement: see Kim and Choi (2019).
The red dot inticates the optimal significance level that minimizes the expected loss: (alpha.opt,beta.opt).
The blue horizontal line indicates the case of alpha = 0.05 as a reference point.      

}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
Leamer, E. 1978, Specification Searches: Ad Hoc Inference with Nonexperimental Data, Wiley, New York.

Kim, JH and Ji, P. 2015, Significance Testing in Empirical Finance: A Critical Review and Assessment, Journal of Empirical Finance 34, 1-14.
<DOI:http://dx.doi.org/10.1016/j.jempfin.2015.08.006>
}
\examples{

data(data1)
# Define Y and X
y=data1$lnoutput; x=cbind(data1$lncapital,data1$lnlabor)
# Restriction matrices to test for constant returns to scale
Rmat=matrix(c(0,1,1),nrow=1); rvec=matrix(0.94,nrow=1)
# Model Estimation and F-test
M=R.OLS(y,x,Rmat,rvec) 

# Degrees of Freedom and estimate of non-centrality parameter 
K=ncol(x)+1; T=length(y)
df1=nrow(Rmat);df2=T-K; NCP=M$ncp

# Optimal level of Significance: Under Normality
OptSig.F(df1,df2,ncp=NCP,p=0.5,k=1, Figure=TRUE)
}
\keyword{ htest }% use one of  RShowDoc("KEYWORDS")

