% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPALMOobject.R
\name{createPALMOobject}
\alias{createPALMOobject}
\title{createPALMOobject Function}
\usage{
createPALMOobject(anndata, data)
}
\arguments{
\item{anndata}{Annotation dataframe. It consist of information such as
\emph{Sample} (sample name), \emph{PTID} (donor/participant), \emph{Time}
(longitudinal timepoints)}

\item{data}{Data can be bulk data or single cell data}
}
\value{
PALMO S4 object
}
\description{
This function allows to create PALMO object using Annotation dataframe and
Data dataframe. The Data can be bulk data or single cell data. The bulk input
data should consists of rows as genes/proteins/features and column as Sample
name (same as user-defined Samples in Annotation dataframe). The single cell
data should be Seurat object (please check
https://search.r-project.org/CRAN/refmans/SeuratObject/html/CreateSeuratObject.html).
In case Seurat object not available then user can use function
createPALMOfromsinglecellmatrix to create PALMO object. The Seurat
object/metadata should have Sample column curesponding to Annotation
dataframe.
}
\examples{
\dontrun{
palmo_obj=createPALMOobject(anndata, data)
}
}
\keyword{createPALMOobject}
